/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public interface FetchParentAccess
extends Initializer {
    public @Nullable FetchParentAccess findFirstEntityDescriptorAccess();

    default public @Nullable EntityInitializer findFirstEntityInitializer() {
        EntityInitializer entityInitializer = this.asEntityInitializer();
        if (entityInitializer != null) {
            return entityInitializer;
        }
        FetchParentAccess entityDescriptorAccess = this.findFirstEntityDescriptorAccess();
        return entityDescriptorAccess == null ? null : entityDescriptorAccess.asEntityInitializer();
    }

    public @Nullable Object getParentKey();

    @Override
    public NavigablePath getNavigablePath();

    public void registerResolutionListener(Consumer<Object> var1);

    default public @Nullable FetchParentAccess getFetchParentAccess() {
        return null;
    }

    public @Nullable FetchParentAccess getOwningParent();

    public static @Nullable FetchParentAccess determineOwningParent(@Nullable FetchParentAccess parentAccess) {
        if (parentAccess == null || parentAccess.isEntityInitializer() || parentAccess.isCollectionInitializer() || parentAccess.isEmbeddableInitializer() && parentAccess.isResultInitializer()) {
            return parentAccess;
        }
        return parentAccess.getOwningParent();
    }

    public @Nullable EntityMappingType getOwnedModelPartDeclaringType();

    public static @Nullable EntityMappingType determineOwnedModelPartDeclaringType(ModelPart modelPart, @Nullable FetchParentAccess parentAccess, @Nullable FetchParentAccess owningParent) {
        EntityInitializer entityInitializer;
        if (owningParent == null || (entityInitializer = owningParent.asEntityInitializer()) == null) {
            return null;
        }
        while (parentAccess != null && parentAccess != owningParent) {
            modelPart = parentAccess.getInitializedPart();
            parentAccess = parentAccess.getFetchParentAccess();
        }
        if (modelPart != null && entityInitializer.getEntityDescriptor().getEntityMetamodel().isPolymorphic()) {
            return modelPart.asAttributeMapping() != null ? modelPart.asAttributeMapping().getDeclaringType().findContainingEntityMapping() : modelPart.asEntityMappingType();
        }
        return null;
    }

    default public boolean shouldSkipInitializer(RowProcessingState rowProcessingState) {
        if (this.isPartOfKey()) {
            return false;
        }
        FetchParentAccess owningParent = this.getOwningParent();
        if (owningParent != null) {
            if (owningParent instanceof AbstractImmediateCollectionInitializer) {
                AbstractImmediateCollectionInitializer collectionInitializer = (AbstractImmediateCollectionInitializer)owningParent;
                return collectionInitializer.resolveCollectionKey(rowProcessingState) == null;
            }
            EntityInitializer entityInitializer = owningParent.asEntityInitializer();
            if (entityInitializer == null) {
                if (!(1.$assertionsDisabled || owningParent.isEmbeddableInitializer() && owningParent.isResultInitializer())) {
                    throw new AssertionError();
                }
                return false;
            }
            entityInitializer.resolveKey(rowProcessingState);
            EntityPersister concreteDescriptor = entityInitializer.getConcreteDescriptor();
            if (concreteDescriptor == null) {
                return true;
            }
            if ((entityInitializer.getEntityKey() == null || entityInitializer.isEntityInitialized()) && rowProcessingState.getQueryOptions().isResultCachingEnabled() != Boolean.TRUE) {
                return true;
            }
            EntityMappingType declaringType = this.getOwnedModelPartDeclaringType();
            if (declaringType != null && concreteDescriptor != declaringType) {
                return !declaringType.getSubclassEntityNames().contains(concreteDescriptor.getEntityName());
            }
        }
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

