/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer
implements CollectionInitializer {
    private final NavigablePath collectionPath;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    protected final PluralAttributeMapping collectionAttributeMapping;
    protected final boolean isResultInitializer;
    protected final @Nullable FetchParentAccess parentAccess;
    protected final @Nullable DomainResultAssembler<?> collectionKeyResultAssembler;
    protected @Nullable PersistentCollection<?> collectionInstance;
    protected @Nullable CollectionKey collectionKey;
    protected boolean parentShallowCached;
    protected State state = State.UNINITIALIZED;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, @Nullable DomainResult<?> collectionKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        this.collectionPath = collectionPath;
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(collectionAttributeMapping, parentAccess, this.owningParent);
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.isResultInitializer = isResultInitializer;
        this.parentAccess = parentAccess;
        this.collectionKeyResultAssembler = collectionKeyResult == null ? null : collectionKeyResult.createResultAssembler(this, creationState);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        Object collectionKeyValue;
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        CollectionKey oldKey = this.collectionKey;
        PersistentCollection<?> oldCollectionInstance = this.collectionInstance;
        this.collectionKey = null;
        this.collectionInstance = null;
        this.state = State.MISSING;
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            return;
        }
        if (this.collectionKeyResultAssembler == null) {
            assert (this.parentAccess != null);
            collectionKeyValue = this.parentAccess.getParentKey();
        } else {
            collectionKeyValue = this.collectionKeyResultAssembler.assemble(rowProcessingState);
        }
        if (collectionKeyValue != null) {
            CollectionPersister persister = this.collectionAttributeMapping.getCollectionDescriptor();
            if (oldKey != null && persister.getKeyType().isEqual(oldKey.getKey(), collectionKeyValue)) {
                this.collectionKey = oldKey;
                this.collectionInstance = oldCollectionInstance;
                this.state = oldCollectionInstance == null ? State.MISSING : State.RESOLVED;
            } else {
                this.collectionKey = new CollectionKey(persister, collectionKeyValue);
                this.state = State.KEY_RESOLVED;
            }
            if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Current row collection key : %s", (Object)this.getClass().getSimpleName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        }
    }

    protected void resolveInstance(RowProcessingState rowProcessingState, boolean isEager) {
        if (this.state == State.KEY_RESOLVED) {
            assert (this.parentAccess != null);
            EntityInitializer entityInitializer = this.parentAccess.findFirstEntityInitializer();
            if (entityInitializer != null && entityInitializer.isEntityInitialized()) {
                this.state = State.MISSING;
                return;
            }
            this.state = State.RESOLVED;
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            FetchParentAccess fetchParentAccess = this.parentAccess.findFirstEntityDescriptorAccess();
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(this.collectionKey);
            if (loadingEntry != null) {
                this.collectionInstance = loadingEntry.getCollectionInstance();
                if (this.collectionInstance.getOwner() == null) {
                    fetchParentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
                }
                return;
            }
            PersistentCollection<?> existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                if (this.collectionInstance.getOwner() == null) {
                    fetchParentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
                }
                return;
            }
            CollectionPersister collectionDescriptor = this.collectionAttributeMapping.getCollectionDescriptor();
            CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
            Object key = this.collectionKey.getKey();
            this.collectionInstance = collectionSemantics.instantiateWrapper(key, collectionDescriptor, session);
            fetchParentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, key);
            if (isEager) {
                persistenceContext.addNonLazyCollection(this.collectionInstance);
            }
            if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                session.getPersistenceContext().addCollectionHolder(this.collectionInstance);
            }
        }
    }

    @Override
    public @Nullable PersistentCollection<?> getCollectionInstance() {
        return this.state == State.UNINITIALIZED || this.state == State.MISSING ? null : this.collectionInstance;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    @Override
    public @Nullable FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public @Nullable FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.parentAccess == null ? null : this.parentAccess.findFirstEntityDescriptorAccess();
    }

    @Override
    public Object getParentKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> resolvedParentConsumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPartOfKey() {
        return false;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    @Override
    public @Nullable CollectionKey resolveCollectionKey(RowProcessingState rowProcessingState) {
        this.resolveKey(rowProcessingState);
        return this.collectionKey;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.state = State.UNINITIALIZED;
    }

    @Override
    public void markShallowCached() {
        this.parentShallowCached = true;
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        this.parentShallowCached = false;
    }

    protected static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        RESOLVED,
        INITIALIZED;

    }
}

