/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.Collection;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyEntry;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final FetchParentAccess parentAccess;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    private final boolean isPartOfKey;
    private final DomainResultAssembler<?> identifierAssembler;
    private final BasicResultAssembler<?> discriminatorAssembler;
    private final DomainResultAssembler<?> versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final DomainResultAssembler<?>[][] assemblers;
    private boolean shallowCached;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object version;
    private Object entityInstance;
    protected Object entityInstanceForNotify;
    private EntityHolder holder;
    protected State state = State.UNINITIALIZED;
    private boolean isOwningInitializer;
    private Object[] resolvedEntityState;

    @Deprecated(forRemoval=true)
    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, AssemblerCreationState creationState) {
        this(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, rowIdResult, null, creationState);
    }

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.parentAccess = parentAccess;
        assert (lockMode != null);
        this.isPartOfKey = Initializer.isPartOfKey(navigablePath, parentAccess);
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(this.referencedModelPart, parentAccess, this.owningParent);
        assert (identifierFetch != null || this.isResultInitializer()) : "Identifier must be fetched, unless this is a result initializer";
        DomainResultAssembler<?> domainResultAssembler = this.identifierAssembler = identifierFetch != null ? identifierFetch.createAssembler(this, creationState) : null;
        assert (this.entityDescriptor.hasSubclasses() == (discriminatorFetch != null)) : "Discriminator should only be fetched if the entity has subclasses";
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        Collection<EntityMappingType> subMappingTypes = this.rootEntityDescriptor.getSubMappingTypes();
        this.assemblers = new DomainResultAssembler[subMappingTypes.size() + 1][];
        this.assemblers[this.rootEntityDescriptor.getSubclassId()] = new DomainResultAssembler[this.rootEntityDescriptor.getNumberOfFetchables()];
        for (EntityMappingType subMappingType : subMappingTypes) {
            this.assemblers[subMappingType.getSubclassId()] = new DomainResultAssembler[subMappingType.getNumberOfFetchables()];
        }
        int size = this.entityDescriptor.getNumberOfFetchables();
        for (int i = 0; i < size; ++i) {
            AttributeMapping attributeMapping = this.entityDescriptor.getFetchable(i).asAttributeMapping();
            Fetch fetch = resultDescriptor.findFetch(attributeMapping);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            int stateArrayPosition = attributeMapping.getStateArrayPosition();
            EntityMappingType declaringType = attributeMapping.getDeclaringType().asEntityMappingType();
            this.assemblers[declaringType.getSubclassId()][stateArrayPosition] = stateAssembler;
            for (EntityMappingType subMappingType : declaringType.getSubMappingTypes()) {
                this.assemblers[subMappingType.getSubclassId()][stateArrayPosition] = stateAssembler;
            }
        }
    }

    private static void deepCopy(ManagedMappingType containerDescriptor, Object[] source, Object[] target) {
        int numberOfAttributeMappings = containerDescriptor.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = containerDescriptor.getAttributeMapping(i);
            AttributeMetadata attributeMetadata = attributeMapping.getAttributeMetadata();
            if (!attributeMetadata.isUpdatable()) continue;
            int position = attributeMapping.getStateArrayPosition();
            target[position] = AbstractEntityInitializer.copy(attributeMetadata, source[position]);
        }
    }

    private static Object copy(AttributeMetadata attributeMetadata, Object sourceValue) {
        return sourceValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || sourceValue == PropertyAccessStrategyBackRefImpl.UNKNOWN ? sourceValue : attributeMetadata.getMutabilityPlan().deepCopy(sourceValue);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    protected void setEntityInstance(Object entityInstance) {
        this.entityInstance = entityInstance;
    }

    public Object getKeyValue() {
        return this.entityKey == null ? null : this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.state == State.RESOLVED || this.state == State.INITIALIZED) {
            listener.accept(this.entityInstanceForNotify);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        if (rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout() && !this.isParentShallowCached()) {
            this.shallowCached = true;
            this.markSubInitializersAsShallowCached();
        }
    }

    @Override
    public void markShallowCached() {
        super.markShallowCached();
        this.markSubInitializersAsShallowCached();
    }

    private void markSubInitializersAsShallowCached() {
        DomainResultAssembler<?>[][] domainResultAssemblerArray = this.assemblers;
        int n = domainResultAssemblerArray.length;
        for (int i = 0; i < n; ++i) {
            DomainResultAssembler<?>[] subtypeAssemblers;
            for (DomainResultAssembler<?> assembler : subtypeAssemblers = domainResultAssemblerArray[i]) {
                Initializer initializer;
                if (assembler == null || (initializer = assembler.getInitializer()) == null) continue;
                initializer.markShallowCached();
            }
        }
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.state == State.UNINITIALIZED) {
            Object id;
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
            }
            if ((id = this.initializeIdentifier(rowProcessingState)) == null) {
                this.state = State.MISSING;
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
            } else if (this.concreteDescriptor != null || (this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState)) != null) {
                this.entityKey = new EntityKey(id, this.concreteDescriptor);
                this.state = State.KEY_RESOLVED;
                if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                    EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), this.entityKey.getIdentifier());
                }
            }
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState) throws WrongClassException {
        if (this.discriminatorAssembler == null || rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout() && !this.entityDescriptor.storeDiscriminatorInShallowQueryCacheLayout()) {
            return this.entityDescriptor;
        }
        assert (this.entityDescriptor.hasSubclasses()) : "Reading a discriminator from a result set should only happen if the entity has subclasses";
        EntityDiscriminatorMapping discriminatorMapping = this.entityDescriptor.getDiscriminatorMapping();
        assert (discriminatorMapping != null);
        Object discriminator = this.discriminatorAssembler.extractRawValue(rowProcessingState);
        DiscriminatorValueDetails discriminatorDetails = discriminatorMapping.resolveDiscriminatorValue(discriminator);
        if (discriminatorDetails == null) {
            return this.entityDescriptor;
        }
        EntityMappingType indicatedEntity = discriminatorDetails.getIndicatedEntity();
        if (indicatedEntity.isTypeOrSuperType(this.entityDescriptor)) {
            return indicatedEntity.getEntityPersister();
        }
        throw new WrongClassException(indicatedEntity.getEntityName(), null, this.entityDescriptor.getEntityName(), discriminator);
    }

    private Object initializeIdentifier(RowProcessingState rowProcessingState) {
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        Object id = jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId();
        if (this.useEmbeddedIdentifierInstanceAsEntity(id, rowProcessingState)) {
            this.entityInstance = this.entityInstanceForNotify = id;
            return id;
        }
        if (this.identifierAssembler == null) {
            assert (id != null) : "Initializer requires a not null id for loading";
            return id;
        }
        return this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
    }

    private boolean useEmbeddedIdentifierInstanceAsEntity(Object id, RowProcessingState rowProcessingState) {
        return id != null && this.isResultInitializer() && this.entityDescriptor.getIdentifierMapping() instanceof CompositeIdentifierMapping && !((CompositeIdentifierMapping)this.entityDescriptor.getIdentifierMapping()).hasContainingClass() && (this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState)) != null && this.concreteDescriptor.isInstance(id);
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.state == State.KEY_RESOLVED) {
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
            this.holder = persistenceContext.claimEntityHolderIfPossible(this.entityKey, null, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
            this.state = State.RESOLVED;
            boolean bl = this.isOwningInitializer = this.holder.getEntityInitializer() == this;
            if (this.entityInstance == null) {
                String uniqueKeyAttributePath;
                this.resolveEntityInstance(rowProcessingState, this.holder, this.entityKey.getIdentifier());
                if (this.isResultInitializer() && (uniqueKeyAttributePath = rowProcessingState.getEntityUniqueKeyAttributePath()) != null) {
                    SharedSessionContractImplementor session = rowProcessingState.getSession();
                    EntityUniqueKey euk = new EntityUniqueKey(this.getConcreteDescriptor().getEntityName(), uniqueKeyAttributePath, rowProcessingState.getEntityUniqueKey(), this.getConcreteDescriptor().getPropertyType(uniqueKeyAttributePath), session.getFactory());
                    session.getPersistenceContextInternal().addEntity(euk, this.getEntityInstance());
                }
            } else if (!this.isOwningInitializer) {
                this.entityInstance = this.holder.getManagedObject();
                this.entityInstanceForNotify = this.holder.getEntity();
                this.state = State.INITIALIZED;
            }
            this.notifyResolutionListeners(this.entityInstanceForNotify);
            if (this.shallowCached) {
                this.initializeSubInstancesFromParent(rowProcessingState);
            }
        }
    }

    protected void resolveEntityInstance(RowProcessingState rowProcessingState, EntityHolder holder, Object entityIdentifier) {
        Object proxy;
        boolean unwrapProxy;
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        boolean bl = unwrapProxy = (proxy = holder.getProxy()) != null && this.referencedModelPart instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.referencedModelPart).isUnwrapProxy() && this.getConcreteDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        if (!unwrapProxy && this.isProxyInstance(proxy)) {
            Object entityFromExecutionContext = this.getEntityFromExecutionContext(rowProcessingState);
            if (entityFromExecutionContext != null) {
                this.entityInstance = this.entityInstanceForNotify = entityFromExecutionContext;
                this.registerReloadedEntity(rowProcessingState, holder);
            } else {
                this.entityInstance = proxy;
                if (Hibernate.isInitialized(this.entityInstance)) {
                    this.state = State.INITIALIZED;
                    this.entityInstanceForNotify = Hibernate.unproxy(this.entityInstance);
                    this.registerReloadedEntity(rowProcessingState, holder);
                    if (!rowProcessingState.isQueryCacheHit() && rowProcessingState.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE) {
                        this.resolveState(rowProcessingState);
                    }
                } else {
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
                    assert (lazyInitializer != null);
                    this.entityInstanceForNotify = this.resolveInstance(entityIdentifier, holder, rowProcessingState);
                    lazyInitializer.setImplementation(this.entityInstanceForNotify);
                }
            }
        } else {
            Object existingEntity = holder.getEntity();
            if (existingEntity != null) {
                this.entityInstance = this.entityInstanceForNotify = existingEntity;
                if (holder.getEntityInitializer() == null) {
                    if (this.isExistingEntityInitialized(existingEntity)) {
                        this.state = State.INITIALIZED;
                        this.registerReloadedEntity(rowProcessingState, holder);
                        if (!rowProcessingState.isQueryCacheHit() && rowProcessingState.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE) {
                            this.resolveState(rowProcessingState);
                        }
                    } else if (this.isResultInitializer()) {
                        this.registerLoadingEntity(rowProcessingState, this.entityInstance);
                    }
                }
            } else {
                Object entityFromExecutionContext = this.getEntityFromExecutionContext(rowProcessingState);
                if (entityFromExecutionContext != null) {
                    this.entityInstance = this.entityInstanceForNotify = entityFromExecutionContext;
                    if (this.isResultInitializer()) {
                        this.registerLoadingEntity(rowProcessingState, this.entityInstance);
                    }
                } else {
                    this.entityInstance = this.entityInstanceForNotify = this.resolveInstance(entityIdentifier, holder, rowProcessingState);
                    if (this.isOwningInitializer && !this.isEntityInitialized() && this.identifierAssembler instanceof EmbeddableAssembler) {
                        this.identifierAssembler.assemble(rowProcessingState);
                    }
                }
            }
        }
        this.upgradeLockMode(rowProcessingState);
    }

    protected Object getEntityFromExecutionContext(RowProcessingState rowProcessingState) {
        ExecutionContext executionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext();
        if (this.rootEntityDescriptor == executionContext.getRootEntityDescriptor() && this.getEntityKey().getIdentifier().equals(executionContext.getEntityId())) {
            return executionContext.getEntityInstance();
        }
        return null;
    }

    private void upgradeLockMode(RowProcessingState rowProcessingState) {
        EntityEntry entry;
        if (this.lockMode != LockMode.NONE && rowProcessingState.upgradeLocks() && (entry = rowProcessingState.getSession().getPersistenceContextInternal().getEntry(this.entityInstance)) != null && entry.getLockMode().lessThan(this.lockMode)) {
            if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                this.checkVersion(entry, rowProcessingState);
            }
            entry.setLockMode(this.lockMode);
        }
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        return Hibernate.isInitialized(existingEntity);
    }

    private void checkVersion(EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object version = entry.getVersion();
        if (version != null) {
            Object currentVersion = this.versionAssembler.assemble(rowProcessingState);
            if (!this.concreteDescriptor.getVersionType().isEqual(version, currentVersion)) {
                StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(this.concreteDescriptor.getEntityName());
                }
                throw new StaleObjectStateException(this.concreteDescriptor.getEntityName(), entry.getId());
            }
        }
    }

    protected Object resolveInstance(Object entityIdentifier, EntityHolder holder, RowProcessingState rowProcessingState) {
        if (this.isOwningInitializer) {
            assert (holder.getEntity() == null);
            return this.resolveEntityInstance(entityIdentifier, rowProcessingState);
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)holder.getEntityInitializer());
        }
        return holder.getEntity();
    }

    protected Object resolveEntityInstance(Object entityIdentifier, RowProcessingState rowProcessingState) {
        Object cached;
        Object resolved = this.resolveToOptionalInstance(rowProcessingState);
        if (resolved != null) {
            this.registerLoadingEntity(rowProcessingState, resolved);
            return resolved;
        }
        if (rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout()) {
            this.state = State.INITIALIZED;
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            assert (this.isOwningInitializer);
            rowProcessingState.getJdbcValuesSourceProcessingState().getLoadingEntityHolders().remove(this.holder);
            session.getPersistenceContextInternal().removeEntityHolder(this.entityKey);
            return session.internalLoad(this.concreteDescriptor.getEntityName(), entityIdentifier, true, false);
        }
        if (this.entityDescriptor.canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(rowProcessingState)) != null) {
            this.state = State.INITIALIZED;
            this.registerReloadedEntity(rowProcessingState);
            return cached;
        }
        Object instance = this.instantiateEntity(entityIdentifier, rowProcessingState.getSession());
        this.registerLoadingEntity(rowProcessingState, instance);
        return instance;
    }

    protected Object instantiateEntity(Object entityIdentifier, SharedSessionContractImplementor session) {
        Object instance = session.instantiate(this.concreteDescriptor, this.entityKey.getIdentifier());
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)System.identityHashCode(instance));
        }
        return instance;
    }

    private Object resolveToOptionalInstance(RowProcessingState rowProcessingState) {
        if (this.isResultInitializer()) {
            JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean matchesOptionalInstance(JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier());
    }

    private Object resolveInstanceFromCache(RowProcessingState rowProcessingState) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(rowProcessingState.getSession().asEventSource(), null, this.lockMode, this.entityDescriptor, this.entityKey);
    }

    protected void registerLoadingEntity(RowProcessingState rowProcessingState, Object instance) {
        rowProcessingState.getSession().getPersistenceContextInternal().claimEntityHolderIfPossible(this.entityKey, instance, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
    }

    protected void registerReloadedEntity(RowProcessingState rowProcessingState) {
        if (rowProcessingState.hasCallbackActions()) {
            rowProcessingState.getSession().getPersistenceContextInternal().getEntityHolder(this.entityKey).markAsReloaded(rowProcessingState.getJdbcValuesSourceProcessingState());
        }
    }

    protected void registerReloadedEntity(RowProcessingState rowProcessingState, EntityHolder holder) {
        if (rowProcessingState.hasCallbackActions()) {
            holder.markAsReloaded(rowProcessingState.getJdbcValuesSourceProcessingState());
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.state == State.KEY_RESOLVED || this.state == State.RESOLVED) {
            this.initializeEntity(this.entityInstanceForNotify, rowProcessingState);
            this.state = State.INITIALIZED;
        }
    }

    private void initializeEntity(Object toInitialize, RowProcessingState rowProcessingState) {
        if (!this.skipInitialization(toInitialize, rowProcessingState)) {
            assert (this.consistentInstance(toInitialize, rowProcessingState));
            this.initializeEntityInstance(toInitialize, rowProcessingState);
        }
    }

    protected boolean consistentInstance(Object toInitialize, RowProcessingState rowProcessingState) {
        PersistenceContext persistenceContextInternal = rowProcessingState.getSession().getPersistenceContextInternal();
        Object entity = persistenceContextInternal.getEntity(this.entityKey);
        return entity == null || entity == toInitialize;
    }

    private void initializeEntityInstance(Object toInitialize, RowProcessingState rowProcessingState) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        Object entityIdentifier = this.entityKey.getIdentifier();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        this.resolvedEntityState = this.extractConcreteTypeStateValues(rowProcessingState);
        this.preLoad(rowProcessingState);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            this.concreteDescriptor.getBytecodeEnhancementMetadata().injectInterceptor(toInitialize, entityIdentifier, session);
        }
        this.concreteDescriptor.setPropertyValues(toInitialize, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, toInitialize);
        this.registerPossibleUniqueKeyEntries(toInitialize, session);
        this.version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = this.lockMode == LockMode.NONE ? LockMode.READ : this.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), this.version, lockModeToAcquire, true, this.concreteDescriptor, false);
        this.registerNaturalIdResolution(persistenceContext, entityIdentifier);
        this.takeSnapshot(rowProcessingState, session, persistenceContext, entityEntry);
        this.concreteDescriptor.afterInitialize(toInitialize, session);
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        assert (this.concreteDescriptor.getIdentifier(toInitialize, session) != null);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(this.concreteDescriptor.getEntityName());
        }
    }

    protected void updateCaches(Object toInitialize, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object entityIdentifier, Object version) {
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        if (!rowProcessingState.isQueryCacheHit() && cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            this.putInCache(toInitialize, session, persistenceContext, entityIdentifier, version, cacheAccess);
        }
    }

    protected void registerNaturalIdResolution(PersistenceContext persistenceContext, Object entityIdentifier) {
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            Object naturalId = this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(this.resolvedEntityState);
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(entityIdentifier, naturalId, this.entityDescriptor);
        }
    }

    protected void takeSnapshot(RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext, EntityEntry entityEntry) {
        if (this.isReallyReadOnly(rowProcessingState, session)) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            AbstractEntityInitializer.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
    }

    private boolean isReallyReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) {
        if (!this.concreteDescriptor.isMutable()) {
            return true;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            return lazyInitializer.isReadOnly();
        }
        return this.isReadOnly(rowProcessingState, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(Object toInitialize, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object entityIdentifier, Object version, EntityDataAccess cacheAccess) {
        SessionFactoryImplementor factory = session.getFactory();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        CacheEntry cacheEntry = this.concreteDescriptor.buildCacheEntry(toInitialize, this.resolvedEntityState, version, session);
        Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
        EventManager eventManager = session.getEventManager();
        if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
            boolean update = false;
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            try {
                update = cacheAccess.update(session, cacheKey, this.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, this.concreteDescriptor, update, EventManager.CacheActionDescription.ENTITY_UPDATE);
            }
        }
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        boolean put = false;
        HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
        try {
            eventListenerManager.cachePutStart();
            put = cacheAccess.putFromLoad(session, cacheKey, this.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
        }
        finally {
            eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, this.concreteDescriptor, put, EventManager.CacheActionDescription.ENTITY_LOAD);
            StatisticsImplementor statistics = factory.getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
            eventListenerManager.cachePutEnd();
        }
    }

    protected void registerPossibleUniqueKeyEntries(Object toInitialize, SharedSessionContractImplementor session) {
        for (UniqueKeyEntry entry : this.concreteDescriptor.uniqueKeyEntries()) {
            String ukName = entry.getUniqueKeyName();
            int index = entry.getStateArrayPosition();
            Type type = entry.getPropertyType();
            if (this.resolvedEntityState[index] == null) continue;
            EntityUniqueKey euk = new EntityUniqueKey(this.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, this.resolvedEntityState[index], type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(euk, toInitialize);
        }
    }

    protected Object[] extractConcreteTypeStateValues(RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.concreteDescriptor.getNumberOfAttributeMappings()];
        DomainResultAssembler<?>[] concreteAssemblers = this.assemblers[this.concreteDescriptor.getSubclassId()];
        for (int i = 0; i < values.length; ++i) {
            DomainResultAssembler<?> assembler = concreteAssemblers[i];
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
        }
        return values;
    }

    private void resolveState(RowProcessingState rowProcessingState) {
        for (DomainResultAssembler<?> assembler : this.assemblers[this.concreteDescriptor.getSubclassId()]) {
            if (assembler == null) continue;
            assembler.resolveState(rowProcessingState);
        }
    }

    protected boolean skipInitialization(Object toInitialize, RowProcessingState rowProcessingState) {
        if (this.holder.isInitialized()) {
            return rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject() != toInitialize;
        }
        EntityEntry entry = rowProcessingState.getSession().getPersistenceContextInternal().getEntry(toInitialize);
        if (entry == null) {
            return false;
        }
        if (entry.getStatus().isDeletedOrGone()) {
            return true;
        }
        if (this.isOwningInitializer) {
            PersistentAttributeInterceptor interceptor;
            if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
                return entry.getStatus() == Status.LOADING;
            }
            if (entry.getStatus() != Status.LOADING) {
                return rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject() != toInitialize;
            }
            return false;
        }
        return true;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    protected void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (session.isEventSource()) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setState(this.resolvedEntityState).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD.fireEventOnEachListener(preLoadEvent, PreLoadEventListener::onPreLoad);
        }
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEntityInitialized() {
        return this.state == State.INITIALIZED;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        assert (this.state != State.UNINITIALIZED);
        return this.concreteDescriptor == null ? this.entityDescriptor : this.concreteDescriptor;
    }

    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        if (this.entityInstanceForNotify != null) {
            DomainResultAssembler<?>[][] domainResultAssemblerArray = this.getAssemblers();
            int n = domainResultAssemblerArray.length;
            for (int i = 0; i < n; ++i) {
                DomainResultAssembler<?>[] subtypeAssemblers;
                for (DomainResultAssembler<?> assembler : subtypeAssemblers = domainResultAssemblerArray[i]) {
                    Initializer initializer;
                    if (assembler == null || (initializer = assembler.getInitializer()) == null) continue;
                    initializer.initializeInstanceFromParent(this.entityInstanceForNotify, rowProcessingState);
                }
            }
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (this.resolvedEntityState != null) {
            this.updateCaches(this.entityInstanceForNotify, rowProcessingState, session, session.getPersistenceContext(), this.entityKey.getIdentifier(), this.version);
        }
        this.isOwningInitializer = false;
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.version = null;
        this.entityInstance = null;
        this.entityInstanceForNotify = null;
        this.resolvedEntityState = null;
        this.state = State.UNINITIALIZED;
        this.clearResolutionListeners();
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        super.endLoading(executionContext);
        this.shallowCached = false;
    }

    protected void setEntityInstanceForNotify(Object entityInstanceForNotify) {
        this.entityInstanceForNotify = entityInstanceForNotify;
    }

    protected Object getEntityInstanceForNotify() {
        return this.entityInstanceForNotify;
    }

    protected void setResolvedEntityState(Object[] resolvedEntityState) {
        this.resolvedEntityState = resolvedEntityState;
    }

    protected Object[] getResolvedEntityState() {
        return this.resolvedEntityState;
    }

    protected DomainResultAssembler<?> getVersionAssembler() {
        return this.versionAssembler;
    }

    protected DomainResultAssembler<Object> getRowIdAssembler() {
        return this.rowIdAssembler;
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected DomainResultAssembler<?>[][] getAssemblers() {
        return this.assemblers;
    }

    protected static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        RESOLVED,
        INITIALIZED;

    }
}

