/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilesystemDataSource
extends BasicDataSource {
    private static Logger log = new Logger(FilesystemDataSource.class.getName());

    private void checkIfEnabled(DSRequest req) throws Exception {
        if (!config.getBoolean((Object)"FilesystemDataSource.enabled", false) && !req.getRPCManager().enableAllDS) {
            throw new Exception("Attempt to instantiate FilesystemDataSource denied. Set FilesystemDataSource.enabled in config to turn it on");
        }
    }

    @Override
    public DSResponse execute(DSRequest req) throws Exception {
        this.checkIfEnabled(req);
        String operationType = req.getOperationType();
        Map criteria = req.getCriteria();
        Map values = req.getValues();
        String webRoot = config.getPath("webRoot");
        if (FilesystemDataSource.isFetch(operationType)) {
            List<Object> fileNames;
            String regex;
            String filePath = (String)criteria.get("path");
            Object listPath = (String)criteria.get("absolutePath");
            if (listPath == null) {
                listPath = (String)criteria.get("parentID");
            }
            boolean listSubTree = DataTools.getBoolean(criteria, "listSubTree");
            boolean returnContent = "loadFile".equals(req.getOperationId());
            log.debug("returnContent is: " + returnContent);
            boolean webrootOnly = true;
            if (criteria.containsKey("webrootOnly")) {
                webrootOnly = DataTools.getBoolean(criteria, "webrootOnly");
                if (ISCFile.inContainerIOMode()) {
                    webrootOnly = true;
                }
            }
            if ((regex = (String)criteria.get("fileFilter")) == null) {
                regex = ".*";
            }
            if (filePath != null) {
                fileNames = new ArrayList<String>();
                filePath = Config.expandPathVariables(filePath, webrootOnly, !webrootOnly);
                fileNames.add(filePath);
            } else {
                listPath = Config.expandPathVariables((String)listPath, webrootOnly, !webrootOnly);
                if (webrootOnly) {
                    log.debug("listing files at: " + (String)listPath);
                    if (listSubTree) {
                        return this.listSubTree(req, (String)listPath, regex);
                    }
                    fileNames = regex.equals(".*") ? ISCFile.list((String)listPath) : ISCFile.list((String)listPath, regex);
                } else {
                    fileNames = new ArrayList();
                    if ("/".equals(listPath) || "\\".equals(listPath)) {
                        File[] roots = File.listRoots();
                        for (File file : roots) {
                            String path = file.getPath();
                            if ("/".equals(path)) continue;
                            fileNames.add(path);
                        }
                    }
                    if (fileNames.isEmpty()) {
                        File dir = new File((String)listPath);
                        if (dir.exists() && !dir.canRead()) {
                            throw new SecurityException("Access denied to " + (String)listPath);
                        }
                        if (!((String)listPath).endsWith("/") && !((String)listPath).endsWith("\\")) {
                            listPath = (String)listPath + File.separator;
                        }
                        for (String string : dir.list()) {
                            fileNames.add((String)listPath + (String)string);
                        }
                    }
                }
                if (fileNames == null) {
                    throw new Exception("Cannot list filesystem contents at " + (String)listPath);
                }
            }
            DSResponse response = FilesystemDataSource.responseForFileList(fileNames, webrootOnly, returnContent);
            if (listPath != null && ((String)listPath).length() > 1 && ((String)listPath).endsWith(File.separator)) {
                listPath = ((String)listPath).substring(0, ((String)listPath).length() - 1);
                listPath = new File((String)listPath).getCanonicalPath();
                if (File.separatorChar != '/') {
                    listPath = ((String)listPath).replace(File.separatorChar, '/');
                }
            }
            response.setProperty("path", listPath);
            return response;
        }
        if (FilesystemDataSource.isUpdate(operationType)) {
            String path = (String)criteria.get("path");
            File file = new File(ISCFile.canonicalizePath(Config.expandPathVariables(path)));
            String contents = (String)values.get("contents");
            if (contents != null) {
                String savePath = (String)values.get("path");
                IOUtil.atomicWrite(contents, file);
            } else {
                String newName = (String)values.get("name");
                String newPath = path.substring(0, path.lastIndexOf("/"));
                File newFile = new File(ISCFile.canonicalizePath(Config.expandPathVariables(newPath + "/" + newName)));
                log.debug("file rename: " + file.getCanonicalPath() + " to: " + newFile.getCanonicalPath());
                if (newFile.exists()) {
                    throw new Exception("File named '" + newName + "' already exists.");
                }
                if (file.exists()) {
                    IOUtil.atomicMove(file, newFile);
                }
            }
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setData(FilesystemDataSource.getFileValues(file));
            dsResponse.setInvalidateCache(true);
            return dsResponse;
        }
        if (FilesystemDataSource.isRemove(operationType)) {
            String path = (String)criteria.get("path");
            File file = new File(ISCFile.canonicalizePath(Config.expandPathVariables(path)));
            log.debug("file remove: " + file.getCanonicalPath());
            if (file.exists()) {
                DataTools.recursiveFileDelete(file);
            }
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setData(values);
            return dsResponse;
        }
        if (FilesystemDataSource.isAdd(operationType)) {
            String path = (String)values.get("path");
            String name = (String)values.get("name");
            String fullPath = ISCFile.canonicalizePath(Config.expandPathVariables(path + "/" + name));
            File file = new File(fullPath);
            log.debug("add: " + file.getCanonicalPath());
            if (file.exists()) {
                throw new Exception("File named '" + name + "' already exists.");
            }
            Boolean isFolder = (Boolean)values.get("isFolder");
            if (isFolder != null && isFolder.booleanValue()) {
                log.debug("dir add: " + file.getCanonicalPath());
                file.mkdirs();
            } else {
                log.debug("file add: " + file.getCanonicalPath());
                file.createNewFile();
            }
            DSResponse dsResponse = new DSResponse();
            dsResponse.setData(FilesystemDataSource.getFileValues(file));
            return dsResponse;
        }
        throw new Exception("Invalid operation: " + operationType);
    }

    public DSResponse listSubTree(DSRequest req, String basePath, String regex) throws Exception {
        List<String> files = ISCFile.ffind(basePath, true, regex);
        return FilesystemDataSource.responseForFileList(files, true);
    }

    public static Map getFileValues(File file) throws Exception {
        HashMap<String, Object> fileInfo = new HashMap<String, Object>();
        String parent = file.getParent();
        if (parent != null) {
            fileInfo.put("parentID", (parent = parent.replace('\\', '/')).endsWith("/") ? parent : parent + "/");
        }
        if (file.getName().length() == 0) {
            fileInfo.put("name", file.getPath());
        } else {
            fileInfo.put("name", file.getName());
        }
        String path = file.getPath().replace('\\', '/');
        fileInfo.put("path", path);
        fileInfo.put("variablePath", Config.contractPathVariables(path));
        fileInfo.put("size", file.length());
        fileInfo.put("lastModified", file.lastModified());
        fileInfo.put("isFolder", file.isDirectory());
        return fileInfo;
    }

    public static DSResponse responseForFileList(List fileNames, boolean webrootRelative) throws Exception {
        return FilesystemDataSource.responseForFileList(fileNames, webrootRelative, false);
    }

    public static DSResponse responseForFileList(List fileNames, boolean webrootRelative, boolean returnContent) throws Exception {
        String webRoot = config.getPath("webRoot");
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < fileNames.size(); ++i) {
            String path = (String)fileNames.get(i);
            Map<String, Object> fileInfo = new HashMap();
            if (webrootRelative) {
                log.warn("using path: " + path);
                ISCFile file = ISCFile.newInstance(path);
                ISCFile absFile = ISCFile.newInstance(webRoot + path);
                String parent = file.getParent();
                if (parent.length() > 2 && parent.charAt(1) == ':') {
                    parent = parent.substring(2);
                }
                fileInfo.put("parentID", (parent = ISCFile.canonicalizePath(parent)).endsWith("/") ? parent : parent + "/");
                fileInfo.put("name", file.getName());
                fileInfo.put("path", path);
                fileInfo.put("variablePath", Config.contractPathVariables(webRoot + path));
                fileInfo.put("size", absFile.length());
                fileInfo.put("lastModified", absFile.lastModified());
                fileInfo.put("isFolder", ISCFile.isDirectory(path));
            } else {
                fileInfo = FilesystemDataSource.getFileValues(new File(path));
            }
            if (returnContent) {
                String filePath = ISCFile.canonicalizePath((String)(webrootRelative ? webRoot + "/" + path : path));
                log.debug("responseForFileList is Loading: " + filePath);
                File realFile = new File(filePath);
                if (!realFile.exists()) {
                    DSResponse res = new DSResponse();
                    res.setData("File not found: " + path);
                    res.setFailure();
                    return res;
                }
                StringWriter sw = new StringWriter();
                IOUtil.copyCharacterStreams(new FileReader(realFile), sw);
                fileInfo.put("contents", sw.toString());
            }
            fileInfo.put("mimeType", DataTools.mimeTypeForFileName(path));
            output.add(fileInfo);
        }
        DSResponse res = new DSResponse();
        res.setData(output);
        res.setStartRow(0L);
        res.setEndRow(output.size());
        res.setTotalRows(output.size());
        res.setSuccess();
        return res;
    }

    @Override
    public DSResponse executeDownload(DSRequest req) throws Exception {
        this.checkIfEnabled(req);
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        String path = (String)criteria.get("absolutePath");
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = new File(path);
        result.put(this.getFilesizeField(fieldName), file.length());
        result.put(fieldName, new FileInputStream(file));
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setData(result);
        return dsResponse;
    }
}

