<#-- @ftlvariable name="app" type="java.util.Map<String, Object>" -->
<#-- @ftlvariable name="ds" type="java.util.Map<String, Object>" -->
<#--
components:
  parameters:
-->
<#macro hybridMode>
    hybridMode:
      name: hybridMode
      description: Hybrid mode allows you to send HTTP requests as usual, but receive the responses in SmartClient DSResponse format.  See any example having the DSResponse label.
      in: query
      schema:
        type: boolean
        default: ${app.defaultHybridMode?c}
</#macro>

<#macro sortBy>
    sortBy:
      name: sortBy
      description: |
        Field name to sort by, prefixed with optional "-" indicating descending sort.

        For example, to sort by the field "userName" in ascending order, set sortBy to just "userName". For descending sort on "userName", set sortBy to "-userName".
        To sort by multiple fields, an array of field names is also supported. For example, to sort by the field "department" in ascending order, followed by the field
        "userName" in descending order, set
         ```
         sortBy=department&sortBy=-userName
         ```
      in: query
      schema:
        type: string
</#macro>
<#macro startRow>
    startRow:
      name: startRow
      description: Starting row of returned server results, when using paged result fetching. Note that startRow and endRow are zero-based - the first record is row zero.
      in: query
      schema:
        type: integer
        default: 0
</#macro>
<#macro endRow>
    endRow:
      name: endRow
      description: End row of returned server results, when using paged result fetching. Note that startRow and endRow are zero-based - the first record is row zero.
      in: query
      schema:
        type: integer
</#macro>
<#macro textMatchStyle defaultValue>
    textMatchStyle:
      name: textMatchStyle
      description: |
        For "fetch" operations, how search criteria should be interpreted for text fields:

           - **exact**: for exact match
           - **exactCase**: for case-sensitive exact match
           - **startsWith**: for matching at the beginning only
           - **substring**: for substring match.

        All textMatchStyle settings except "exactCase" are case-insensitive; use AdvancedCriteria for greater control over matching.
      in: query
      schema:
        type: string
        enum:
          - exact
          - exactCase
          - substring
          - startsWith
        default: ${defaultValue}
</#macro>

<#macro pathToKey>
    <#if ds.primaryKey??>
    pathToKey:
      name: ${ds.primaryKey}
      in: path
      required: true
      schema:
        type: string
  </#if>
</#macro>

<#--
paths:
  /:
    post:
      parameters:
-->
<#macro dataFormat defaultValue>
        - name: ${app.dynamicDataFormatParamName}
          description: This governs whether the server expects request bodies to be encoded as XML or JSON, and further influences which format is returned.
          in: query
          schema:
            type: string
            default: ${defaultValue}
            enum:
              - json
              - xml
</#macro>