package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.SortDirection;
import com.smartgwt.client.types.SummaryFunctionType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class DistinctValuesSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "The Server Summaries feature makes it simple to get all of the unique values of a field, similar\r" +
        "to a SQL \"SELECT DISTINCT\" query.  To do this, use <code>groupBy</code> but without declaring\r" +
        "<code>summaryFunctions</code>.\r" +
        "<p>\r" +
        "In this sample, the \"Item\" drop-down uses this technique to display the \r" +
        "unique <code>itemDescription</code> values from the <code>orderItem</code> dataSource\r" +
        "<i>(Green Widget, Orange component, ...)</i>.\r" +
        "<P>\r" +
        "Selecting an item from the \"Item\" drop-down filters the grid below by the selected item.<br>\r" +
        "The grid itself showing aggregated data that matches this criteria. \r" +
        "It shows total quantity and average price for records matching the chosen item, grouped by customer.";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	DistinctValuesSample panel = new DistinctValuesSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderItemList = new ListGrid();
    	orderItemList.setDataSource(DataSource.get("distinctValues_orderItem"));
    	orderItemList.setWidth(400);
    	orderItemList.setHeight(300);
    	orderItemList.setShowFilterEditor(true);
    	orderItemList.setAutoFetchData(false);
    	orderItemList.setCanEdit(false);
    	orderItemList.setCanRemoveRecords(false);
    	orderItemList.setWrapHeaderTitles(true);
    	orderItemList.setHeaderHeight(45);
    	orderItemList.setSortField(0);
    	orderItemList.setSortDirection(SortDirection.ASCENDING);
    	
    	ListGridField orderCustomerName = new ListGridField("orderCustomerName");
    	orderCustomerName.setWidth("*");
    	orderCustomerName.setTitle("Customer name");
    	ListGridField unitPrice = new ListGridField("unitPrice");
    	unitPrice.setType(ListGridFieldType.FLOAT);
    	unitPrice.setWidth(100);
    	unitPrice.setTitle("Avg Price");
    	unitPrice.setFormat("#,##0.00");    	
    	ListGridField quantity = new ListGridField("quantity");
    	quantity.setType(ListGridFieldType.INTEGER);
    	quantity.setTitle("Total Quantity");
    	quantity.setWidth(100);
    	
    	orderItemList.setFields(orderCustomerName,quantity,unitPrice);    	
    	
        DynamicForm itemsForm = new DynamicForm();
        itemsForm.setWidth(300);
        
        SelectItem itemDescription = new SelectItem();
        itemDescription.setName("itemDescription");
        itemDescription.setTitle("Item");
        itemDescription.setAutoFetchData(true);
        itemDescription.setOptionDataSource(DataSource.get("distinctValues_orderItem"));
        DSRequest dsRequestProperties = new DSRequest();
        dsRequestProperties.setGroupBy("itemDescription");
        itemDescription.setOptionFilterContext(dsRequestProperties);
        itemDescription.setDefaultToFirstOption(false);
        
        itemDescription.addChangedHandler(new ChangedHandler() {
			@Override
			public void onChanged(ChangedEvent event) {
				String value = event.getValue().toString();
				DSRequest requestProperties = new DSRequest();
				Map<String,SummaryFunctionType> summaryFunctions = new HashMap<String,SummaryFunctionType>();
				summaryFunctions.put("unitPrice", SummaryFunctionType.AVG);
				summaryFunctions.put("quantity", SummaryFunctionType.SUM);
				requestProperties.setSummaryFunctions(summaryFunctions);
				requestProperties.setGroupBy("orderCustomerName");
				Criteria criteria = new Criteria();
				criteria.addCriteria("itemDescription", value);
				orderItemList.fetchData(criteria, null, requestProperties);
				
			}
        });
        itemsForm.setFields(itemDescription);
        		
        VStack vStack = new VStack();
        vStack.setWidth100();
        vStack.setMembersMargin(10);
        vStack.setMembers(itemsForm,orderItemList);
        
        return vStack;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("distinctValues_order.ds.xml", XML, "source/distinctValues_order.ds.xml.html", true)
        };
    }
}
