package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates how a given Calendar Save was initiated - values are <i>dialog</i>, <i>editor</i> and <i>mouse</i>.
 */
public enum CalendarSaveScenario implements ValueEnum {
    /**
     * the user saved via the {@link com.smartgwt.client.widgets.calendar.Calendar#getEventDialog Calendar.eventDialog}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "dialog".
     */
    DIALOG("dialog"),
    /**
     * the user saved via the {@link com.smartgwt.client.widgets.calendar.Calendar#getEventEditor Calendar.eventEditor}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "editor".
     */
    EDITOR("editor"),
    /**
     * the user moved or resized an {@link com.smartgwt.client.widgets.calendar.EventCanvas event} with the mouse
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "mouse".
     */
    MOUSE("mouse");
    private String value;

    CalendarSaveScenario(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
