/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Parameters to an asynchronous operation.
 * @see com.smartgwt.client.util.AsyncOperationContext
 */
@BeanFactory.FrameworkClass
public class AsyncOperationParams extends RefDataClass {

    public static AsyncOperationParams getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof AsyncOperationParams) {
            existingObj.setJsObj(jsObj);
            return (AsyncOperationParams)existingObj;
        } else

        {
            return new AsyncOperationParams(jsObj);
        }
    }
        


    public AsyncOperationParams(){
        
    }

    public AsyncOperationParams(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * A {@link com.smartgwt.client.util.CancellationController} that the asynchronous operation should look to for whether the
     * operation is canceled. <p> This may be <code>null</code> if the invoker of the asynchronous operation does not need the
     * ability to cancel. However, note that the {@link com.smartgwt.client.util.AsyncOperationResult#getType result type} may
     * still be CANCELED; for example, the asynchronous operation may be self-canceling after a timeout. <p> Implementations of
     * asynchronous operations must treat this <code>CancellationController</code> as observe-only, and they cannot {@link
     * com.smartgwt.client.util.CancellationController#cancel cancel} it.
     *
     * @param cancellationController New cancellationController value. Default value is null
     * @return {@link com.smartgwt.client.util.AsyncOperationParams AsyncOperationParams} instance, for chaining setter calls
     */
    public AsyncOperationParams setCancellationController(CancellationController cancellationController) {
        return (AsyncOperationParams)setAttribute("cancellationController", cancellationController == null ? null : cancellationController.getOrCreateJsObj());
    }

    /**
     * A {@link com.smartgwt.client.util.CancellationController} that the asynchronous operation should look to for whether the
     * operation is canceled. <p> This may be <code>null</code> if the invoker of the asynchronous operation does not need the
     * ability to cancel. However, note that the {@link com.smartgwt.client.util.AsyncOperationResult#getType result type} may
     * still be CANCELED; for example, the asynchronous operation may be self-canceling after a timeout. <p> Implementations of
     * asynchronous operations must treat this <code>CancellationController</code> as observe-only, and they cannot {@link
     * com.smartgwt.client.util.CancellationController#cancel cancel} it.
     *
     * @return Current cancellationController value. Default value is null
     */
    public CancellationController getCancellationController()  {
        return CancellationController.getOrCreateRef(getAttributeAsJavaScriptObject("cancellationController"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
