
package com.smartgwt.client.docs;

/**
 * <h3>Understanding scroll behavior</h3>
 * Some UI frameworks automatically scroll elements into view before interacting with them. If
 * components redraw  during scroll (e.g., to render new list rows), the DOM may change
 * mid-interaction. <P> <b>Best practices</b> <ul> <li>Ensure the target is already in view before
 * triggering actions.</li> <li>Use programmatic scrolling when needed to position elements
 * predictably.</li> <li>Account for custom scrollbars, which may require using framework-specific
 * scrolling APIs rather than  native browser scroll methods.</li> </ul>
 */
public interface ScrollingBehavior {
}
