/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util.workflow;

import com.smartgwt.client.util.workflow.Task;
import com.smartgwt.client.util.workflow.Process;
import java.util.Map;

public interface RunTaskCallback {

    /** 
     * Called when {@link com.smartgwt.client.util.workflow.Process#runTask Process.runTask()} has finished executing the
     * specified task.
     *
     * @param task The task instance that was executed.
     * @param process The owning process instance.
     * @param outputs Task outputs, if any (for  CoTTask, this        is the final <code>$outputs</code> JSON). May be null if the task does
     * not        produce outputs.
     */
	public void execute(Task task, Process process, Map outputs);
} 
