
/*
 * Isomorphic Smart GWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
/* sgwtgen */
package com.smartgwt.client.docs.serverds;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.docs.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.List;
import java.util.Map;

/**
 * Defines the method of the {@link com.smartgwt.client.docs.serverds.ServerObject} if it appears
 * in an {@link com.smartgwt.client.docs.ApplicationDeclaration Application declaration file}.
 * Method can refer the <code>ServerObject</code> method allowed to be called from the client or
 * can be implemented right in the .app.xml file using the {@link
 * com.smartgwt.client.docs.ServerScript inline server script}.<p>
 * <b>This class is not meant to be created and used, it is actually documentation of settings
 * allowed in a DataSource descriptor (.ds.xml file), for use with Smart GWT Pro Edition and
 * above.
 * See {@link com.smartgwt.client.docs.serverds} for how to use this documentation.</b>
 * <p>
 */
public class VisibleMethod {

    /**
     * The script language if method is implemented via {@link com.smartgwt.client.docs.ServerScript}.
     * If omitted the default system-wide language will be used, defined in {@link
     * com.smartgwt.client.docs.Server_properties server.properties} by setting
     * <code>script.defaultLanguage</code>.
     *
     * <p>Default value is null
     */
    public String language;

    /**
     * Comma or space separated script imports if method is scripted. See the "Java Imports" section 
     * of the {@link com.smartgwt.client.docs.ServerScript} overview.
     *
     * <p>Default value is null
     */
    public String scriptImport;

    /**
     * The script body if method is imlemented via {@link com.smartgwt.client.docs.ServerScript}. The
     * presense of this attribute actually defines that method is scripted. See examples in {@link
     * com.smartgwt.client.docs.ApplicationDeclaration Application declaration} overview.
     *
     * <p>Default value is null
     */
    public String script;

    /**
     * The method name. In case if it refers the <code>ServerObject</code> method the names must match
     * and it is the only property required. See examples in {@link
     * com.smartgwt.client.docs.ApplicationDeclaration Application declaration} overview.
     *
     * <p>Default value is null
     */
    public String name;

    /**
     * For the methods implemented via {@link com.smartgwt.client.docs.ServerScript} defines the name
     * of the arguments array variable to access parameters passed via  DMI.call() inside the script.
     * See examples in {@link com.smartgwt.client.docs.ApplicationDeclaration Application declaration}
     * overview.
     *
     * <p>Default value is null
     */
    public String args;

}
