/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Configuration object for {@link com.smartgwt.client.util.AutoTest#waitForSystemDone AutoTest.waitForSystemDone()}
 */
@BeanFactory.FrameworkClass
public class SystemWaitConfig extends SystemDoneConfig {

    public static SystemWaitConfig getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new SystemWaitConfig(jsObj);
    }
        


    public SystemWaitConfig(){
        
    }

    public SystemWaitConfig(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Should the system wait for any outstanding  FileLoader requests? to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @param includeFileLoader New includeFileLoader value. Default value is true
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setIncludeFileLoader(Boolean includeFileLoader) {
        return (SystemWaitConfig)setAttribute("includeFileLoader", includeFileLoader);
    }

    /**
     * Should the system wait for any outstanding  FileLoader requests? to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @return Current includeFileLoader value. Default value is true
     */
    public Boolean getIncludeFileLoader()  {
        Boolean result = getAttributeAsBoolean("includeFileLoader", true);
        return result == null ? true : result;
    }
    

    /**
     * Should the system wait for any outstanding {@link com.smartgwt.client.rpc.RPCManager RPC Requests} to complete before
     * {@link com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true? <P> If not explicitly set,
     * {@link com.smartgwt.client.util.AutoTest#implicitNetworkWait implicitNetworkWait} will be consulted
     *
     * @param includeNetworkOperations New includeNetworkOperations value. Default value is true
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setIncludeNetworkOperations(Boolean includeNetworkOperations) {
        return (SystemWaitConfig)setAttribute("includeNetworkOperations", includeNetworkOperations);
    }

    /**
     * Should the system wait for any outstanding {@link com.smartgwt.client.rpc.RPCManager RPC Requests} to complete before
     * {@link com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true? <P> If not explicitly set,
     * {@link com.smartgwt.client.util.AutoTest#implicitNetworkWait implicitNetworkWait} will be consulted
     *
     * @return Current includeNetworkOperations value. Default value is true
     */
    public Boolean getIncludeNetworkOperations()  {
        Boolean result = getAttributeAsBoolean("includeNetworkOperations", true);
        return result == null ? true : result;
    }
    

    /**
     * Should the system wait for any outstanding redraws to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @param includeRedraws New includeRedraws value. Default value is true
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setIncludeRedraws(Boolean includeRedraws) {
        return (SystemWaitConfig)setAttribute("includeRedraws", includeRedraws);
    }

    /**
     * Should the system wait for any outstanding redraws to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @return Current includeRedraws value. Default value is true
     */
    public Boolean getIncludeRedraws()  {
        Boolean result = getAttributeAsBoolean("includeRedraws", true);
        return result == null ? true : result;
    }
    

    /**
     * Should the system wait for all {@link com.smartgwt.client.widgets.layout.Layout Layouts} to complete pending {@link
     * com.smartgwt.client.widgets.layout.Layout#reflowNow reflows} before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @param includeReflows New includeReflows value. Default value is true
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setIncludeReflows(Boolean includeReflows) {
        return (SystemWaitConfig)setAttribute("includeReflows", includeReflows);
    }

    /**
     * Should the system wait for all {@link com.smartgwt.client.widgets.layout.Layout Layouts} to complete pending {@link
     * com.smartgwt.client.widgets.layout.Layout#reflowNow reflows} before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @return Current includeReflows value. Default value is true
     */
    public Boolean getIncludeReflows()  {
        Boolean result = getAttributeAsBoolean("includeReflows", true);
        return result == null ? true : result;
    }
    

    /**
     * Should the system wait for all outstanding registered  timer actions to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @param includeTimers New includeTimers value. Default value is true
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setIncludeTimers(Boolean includeTimers) {
        return (SystemWaitConfig)setAttribute("includeTimers", includeTimers);
    }

    /**
     * Should the system wait for all outstanding registered  timer actions to complete before {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} returns true?
     *
     * @return Current includeTimers value. Default value is true
     */
    public Boolean getIncludeTimers()  {
        Boolean result = getAttributeAsBoolean("includeTimers", true);
        return result == null ? true : result;
    }
    

    /**
     * Timeout for {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} in ms. <P> If unset a
     * default timeout of 30 seconds will be used.
     *
     * @param timeout New timeout value. Default value is null
     * @return {@link com.smartgwt.client.util.SystemWaitConfig SystemWaitConfig} instance, for chaining setter calls
     */
    public SystemWaitConfig setTimeout(Integer timeout) {
        return (SystemWaitConfig)setAttribute("timeout", timeout);
    }

    /**
     * Timeout for {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} in ms. <P> If unset a
     * default timeout of 30 seconds will be used.
     *
     * @return Current timeout value. Default value is null
     */
    public Integer getTimeout()  {
        return getAttributeAsInt("timeout");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
