/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util.workflow;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Result object for {@link com.smartgwt.client.util.workflow.Process#beforeTaskCommit Process.beforeTaskCommit()}.
 */
@BeanFactory.FrameworkClass
public class TaskResultModifications extends DataClass {

    public static TaskResultModifications getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new TaskResultModifications(jsObj);
    }
        


    public TaskResultModifications(){
        
    }

    public TaskResultModifications(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Global validation errors to attach to the current Task. If provided, the engine treats this as a validation failure
     * (without advancing), merges these errors into the Task's error record, and triggers the normal retry logic (e.g.,
     * CoTTask  CoTTask.maxRetries). The structure may be a DataSource-style validation response or a simple Array of { field,
     * message } objects.
     *
     * @param errors New errors value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.TaskResultModifications TaskResultModifications} instance, for chaining setter calls
     */
    public TaskResultModifications setErrors(Map errors) {
        return (TaskResultModifications)setAttribute("errors", errors);
    }

    /**
     * Global validation errors to attach to the current Task. If provided, the engine treats this as a validation failure
     * (without advancing), merges these errors into the Task's error record, and triggers the normal retry logic (e.g.,
     * CoTTask  CoTTask.maxRetries). The structure may be a DataSource-style validation response or a simple Array of { field,
     * message } objects.
     *
     * @return Current errors value. Default value is null
     */
    public Map getErrors()  {
        return getAttributeAsMap("errors");
    }
    

    /**
     * Optional replacement for the Task's outputs. If provided, this replaces the outputs produced by the Task for the
     * purposes of subsequent validation, state updates, history, and routing.
     *
     * @param outputs New outputs value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.TaskResultModifications TaskResultModifications} instance, for chaining setter calls
     */
    public TaskResultModifications setOutputs(Map outputs) {
        return (TaskResultModifications)setAttribute("outputs", outputs);
    }

    /**
     * Optional replacement for the Task's outputs. If provided, this replaces the outputs produced by the Task for the
     * purposes of subsequent validation, state updates, history, and routing.
     *
     * @return Current outputs value. Default value is null
     */
    public Map getOutputs()  {
        return getAttributeAsMap("outputs");
    }
    

    /**
     * Additional declarative updates to apply to {@link com.smartgwt.client.util.workflow.Process#getState state} before
     * routing. Keys use {@link com.smartgwt.client.docs.SetterPath} semantics.
     *
     * @param stateUpdates New stateUpdates value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.TaskResultModifications TaskResultModifications} instance, for chaining setter calls
     */
    public TaskResultModifications setStateUpdates(Map stateUpdates) {
        return (TaskResultModifications)setAttribute("stateUpdates", stateUpdates);
    }

    /**
     * Additional declarative updates to apply to {@link com.smartgwt.client.util.workflow.Process#getState state} before
     * routing. Keys use {@link com.smartgwt.client.docs.SetterPath} semantics.
     *
     * @return Current stateUpdates value. Default value is null
     */
    public Map getStateUpdates()  {
        return getAttributeAsMap("stateUpdates");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
